/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.blockentity;

import com.momosoftworks.coldsweat.common.block.IceboxBlock;
import com.momosoftworks.coldsweat.common.blockentity.HearthBlockEntity;
import com.momosoftworks.coldsweat.common.container.IceboxContainer;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.config.type.PredicateItem;
import com.momosoftworks.coldsweat.core.init.ParticleTypesInit;
import com.momosoftworks.coldsweat.core.network.ColdSweatPacketHandler;
import com.momosoftworks.coldsweat.core.network.message.BlockDataUpdateMessage;
import com.momosoftworks.coldsweat.data.tag.ModItemTags;
import com.momosoftworks.coldsweat.util.compat.CompatManager;
import com.momosoftworks.coldsweat.util.registries.ModBlockEntities;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import com.momosoftworks.coldsweat.util.registries.ModSounds;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import com.momosoftworks.coldsweat.util.serialization.NBTHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class IceboxBlockEntity
extends HearthBlockEntity
implements MenuProvider,
WorldlyContainer,
LidBlockEntity {
    public static int[] WATERSKIN_SLOTS = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
    public static int[] FUEL_SLOT = new int[]{0};
    LazyOptional<? extends IItemHandler>[] slotHandlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
    List<ServerPlayer> usingPlayers = new ArrayList<ServerPlayer>();
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(Level level, BlockPos pos, BlockState state) {
            if (!IceboxBlockEntity.this.hasSmokeStack()) {
                IceboxBlockEntity.this.f_58857_.m_5594_(null, pos, ModSounds.ICEBOX_OPEN, SoundSource.BLOCKS, 1.0f, level.f_46441_.m_188501_() * 0.2f + 0.9f);
            }
        }

        protected void m_142289_(Level level, BlockPos pos, BlockState state) {
            if (!IceboxBlockEntity.this.hasSmokeStack()) {
                IceboxBlockEntity.this.f_58857_.m_5594_(null, pos, ModSounds.ICEBOX_CLOSE, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }

        protected void m_142148_(Level level, BlockPos pos, BlockState state, int eventId, int eventParam) {
            IceboxBlockEntity.this.signalOpenCount(level, pos, state, eventId, eventParam);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected boolean m_142718_(Player player) {
            AbstractContainerMenu abstractContainerMenu = player.f_36096_;
            if (!(abstractContainerMenu instanceof IceboxContainer)) return false;
            IceboxContainer container = (IceboxContainer)abstractContainerMenu;
            if (!((Object)((Object)container.te)).equals((Object)IceboxBlockEntity.this)) return false;
            return true;
        }
    };
    ChestLidController lidController = new ChestLidController();

    public IceboxBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.ICEBOX, pos, state);
    }

    @Override
    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }

    @Override
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public boolean m_7531_(int id, int type) {
        if (id == 1) {
            this.lidController.m_155377_(type > 0);
            return true;
        }
        return super.m_7531_(id, type);
    }

    protected void signalOpenCount(Level level, BlockPos pos, BlockState state, int eventId, int eventParam) {
        Block block = state.m_60734_();
        level.m_7696_(pos, block, eventId, eventParam);
    }

    private void sendUpdatePacket() {
        this.usingPlayers.removeIf(player -> {
            AbstractContainerMenu patt5819$temp = player.f_36096_;
            if (!(patt5819$temp instanceof IceboxContainer)) return true;
            IceboxContainer iceboxContainer = (IceboxContainer)patt5819$temp;
            if (iceboxContainer.te != this) return true;
            return false;
        });
        ColdSweatPacketHandler.INSTANCE.send(PacketDistributor.NMLIST.with(() -> this.usingPlayers.stream().map(player -> player.f_8906_.f_9742_).toList()), (Object)new BlockDataUpdateMessage((BlockEntity)this));
    }

    @Override
    protected Component m_6820_() {
        return Component.m_237115_((String)"container.cold_sweat.icebox");
    }

    @Override
    public Component m_5446_() {
        return this.m_7770_() != null ? this.m_7770_() : this.m_6820_();
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T te) {
        if (te instanceof IceboxBlockEntity) {
            IceboxBlockEntity iceboxTE = (IceboxBlockEntity)te;
            iceboxTE.tick(level, state, pos);
            if (level.m_5776_()) {
                IceboxBlockEntity.tickAnimateLid(level, pos, state, iceboxTE);
            }
        }
    }

    public static <T extends BlockEntity> void tickAnimateLid(Level level, BlockPos pos, BlockState state, T blockEntity) {
        if (blockEntity instanceof IceboxBlockEntity) {
            IceboxBlockEntity icebox = (IceboxBlockEntity)blockEntity;
            icebox.lidController.m_155374_();
        }
    }

    public void tick(Level level, BlockState state, BlockPos pos) {
        super.tick(level, pos);
        if (!this.f_58859_) {
            this.openersCounter.m_155476_(this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
        if (this.getFuel() > 0) {
            if (!((Boolean)state.m_61143_((Property)IceboxBlock.FROSTED)).booleanValue()) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)IceboxBlock.FROSTED, (Comparable)Boolean.valueOf(true)), 3);
            }
            if (this.ticksExisted % (int)(20.0 / Math.max(1.0, ConfigSettings.TEMP_RATE.get())) == 0) {
                boolean hasItemStacks = false;
                for (int i = 1; i < 10; ++i) {
                    ItemStack stack = this.m_8020_(i);
                    CompoundTag tag = NBTHelper.getTagOrEmpty(stack);
                    double itemTemp = tag.m_128459_("Temperature");
                    if (!stack.m_150930_(ModItems.FILLED_WATERSKIN) || !(itemTemp > -50.0)) continue;
                    hasItemStacks = true;
                    tag.m_128347_("Temperature", Math.max(-50.0, itemTemp - 1.0));
                }
                if (hasItemStacks) {
                    this.setFuel(this.getFuel() - 1);
                }
            }
        } else if (((Boolean)state.m_61143_((Property)IceboxBlock.FROSTED)).booleanValue()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)IceboxBlock.FROSTED, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    @Override
    public int getMaxPaths() {
        return 2000;
    }

    @Override
    public int getSpreadRange() {
        return 16;
    }

    @Override
    public int getMaxInsulationLevel() {
        return 5;
    }

    @Override
    public SoundEvent getFuelDepleteSound() {
        return ModSounds.ICEBOX_DEPLETE;
    }

    @Override
    public boolean hasSmokeStack() {
        return this.hasSmokestack;
    }

    @Override
    protected void tickPaths(int firstIndex, int lastIndex) {
        if (this.hasSmokestack) {
            super.tickPaths(firstIndex, lastIndex);
        }
    }

    @Override
    protected boolean hasSignalFromSides() {
        return Direction.m_235666_().anyMatch(dir -> dir != Direction.UP && this.f_58857_.m_46616_(this.m_58899_().m_121945_(dir), dir));
    }

    @Override
    protected boolean hasSignalFromBack() {
        return false;
    }

    @Override
    public int getItemFuel(ItemStack item) {
        return ConfigHelper.findFirstItemMatching(ConfigSettings.ICEBOX_FUEL, item).map(PredicateItem::value).orElse(0.0).intValue();
    }

    @Override
    protected void storeFuel(ItemStack stack, int amount) {
        if ((double)this.getFuel() < (double)this.getMaxFuel() - (double)Math.abs(amount) * 0.75) {
            if (!stack.hasCraftingRemainingItem() || stack.m_41613_() > 1) {
                int consumeCount = Math.min((int)Math.floor((double)(this.getMaxFuel() - this.getFuel()) / (double)Math.abs(amount)), stack.m_41613_());
                stack.m_41774_(consumeCount);
                this.addFuel(amount * consumeCount);
            } else {
                this.m_6836_(0, stack.getCraftingRemainingItem());
                this.addFuel(amount);
            }
        }
    }

    public int getFuel() {
        return this.getColdFuel();
    }

    public void setFuel(int amount) {
        this.setColdFuel(amount, true);
    }

    @Override
    public void setColdFuel(int amount, boolean update) {
        super.setColdFuel(amount, update);
        this.sendUpdatePacket();
    }

    @Override
    public void addFuel(int amount) {
        this.setColdFuelAndUpdate(this.getColdFuel() + amount);
    }

    @Override
    protected boolean isFuelChanged() {
        return this.ticksExisted % 10 == 0;
    }

    @Override
    protected AbstractContainerMenu m_6555_(int id, Inventory playerInv) {
        return new IceboxContainer(id, playerInv, this);
    }

    public void m_5856_(Player player) {
        super.m_5856_(player);
        this.openersCounter.m_155452_(player, this.f_58857_, this.m_58899_(), this.m_58900_());
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.usingPlayers.add(serverPlayer);
            this.sendUpdatePacket();
        }
    }

    public void m_5785_(Player player) {
        super.m_5785_(player);
        this.openersCounter.m_155468_(player, this.f_58857_, this.m_58899_(), this.m_58900_());
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.usingPlayers.remove(serverPlayer);
        }
    }

    @Override
    protected void tickParticles() {
        if (this.hasSmokestack) {
            super.tickParticles();
        }
    }

    @Override
    public ParticleOptions getAirParticle() {
        return (ParticleOptions)ParticleTypesInit.GROUND_MIST.get();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void spawnAirParticle(int x, int y, int z, Random rand) {
        ParticleStatus status = (ParticleStatus)Minecraft.m_91087_().f_91066_.m_231929_().m_231551_();
        if (status != ParticleStatus.ALL) {
            return;
        }
        BlockPos pos = new BlockPos(x, y, z);
        boolean onGround = !this.f_58857_.m_8055_(pos.m_7495_()).m_60795_();
        float f = rand.nextFloat();
        float f2 = this.spreading ? 0.016f : 0.032f;
        if (f > f2) {
            return;
        }
        float xr = rand.nextFloat();
        float yr = onGround ? 0.1f : rand.nextFloat();
        float zr = rand.nextFloat();
        float xm = rand.nextFloat() / 20.0f - 0.025f;
        float zm = rand.nextFloat() / 20.0f - 0.025f;
        this.f_58857_.m_6493_(onGround ? (ParticleOptions)ParticleTypesInit.GROUND_MIST.get() : (ParticleOptions)ParticleTypesInit.MIST.get(), false, (double)((float)x + xr), (double)((float)y + yr), (double)((float)z + zr), (double)xm, 0.0, (double)zm);
    }

    @Override
    public int m_6643_() {
        return 10;
    }

    public int[] m_7071_(Direction dir) {
        return dir.m_122434_() == Direction.Axis.Y ? WATERSKIN_SLOTS : FUEL_SLOT;
    }

    public boolean m_7155_(int slot, ItemStack stack, @Nullable Direction direction) {
        if (slot == 0) {
            return this.getItemFuel(stack) != 0;
        }
        return stack.m_204117_(ModItemTags.ICEBOX_VALID) || CompatManager.isSpoiledLoaded() && stack.m_41614_();
    }

    public boolean m_7157_(int slot, ItemStack stack, Direction direction) {
        return true;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == ForgeCapabilities.ITEM_HANDLER) {
            if (facing == Direction.UP) {
                return this.slotHandlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.slotHandlers[1].cast();
            }
            return this.slotHandlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    public float m_6683_(float partialTick) {
        return this.lidController.m_155375_(partialTick);
    }
}

